export const toQueryString = params => {
  if (!params)
    return ''

  const sortEntries = ([a], [b]) => {
    if (a > b) return 1
    if (a < b) return -1
    return 0
  }

  const sortedEntries = Object.entries(params)
    .sort(sortEntries)

  const query = new URLSearchParams()
  for (const [key, value] of sortedEntries)
    query.append(key, value || '')

  return query.toString()
}
