const defaults = {
  name: 'Logger',
  level: 0,
  output: console,
  pretty: true,
}

const Logger = (...params) => {
  let options = defaults

  if (
    params.length &&
    typeof params[0] === 'object' &&
    Object.keys(params[0]).every(k => Object.keys(defaults).includes(k))
  )
    options = { ...options, ...params.shift() }

  params = params.map(p => JSON.stringify(p, null, 2))

  const { name, level, output } = options
  const levels = ['debug', 'info', 'warn', 'error']
  const printers = {}
  levels.forEach(levelName => {
    if (output[levelName] && typeof output[levelName] === 'function')
      printers[levelName] = output[levelName]
    else {
      const prefix = (...what) => what.map(w => `${levelName}: ` + w)

      if (output.info && typeof output.info === 'function')
        printers[levelName] = (...what) => output.info(...prefix(...what))
      else if (typeof output === 'function')
        printers[levelName] = (...what) => output(...prefix(...what))
    }
  })
  const logger = (...what) => output.info(...what)

  levels.forEach((levelName, i) => {
    if (i < level)
      logger[levelName] = () => {}
    else {
      logger[levelName] = (...args) => {
        printers[levelName](`[${name}]`, ...args)
      }
      logger[levelName].multi = (...args) => {
        args.forEach(arg => {
          printers[levelName](`[${name}]`, arg)
        })
      }
    }
  })
  logger.log = logger.info

  logger.multi = (...args) => {
    args.forEach(arg => {
      logger.info(arg)
    })
  }
  levels.forEach(levelName => {
    logger.multi[levelName] = (...args) => {
      args.forEach(arg => {
        logger[levelName](arg)
      })
    }
  })

  if (params.length)
    logger.info(...params)

  return logger
}

export {
  Logger as default,
  Logger,
}
