import auth from './auth.mjs'
import Logger from './logger.mjs'
import precision from './precision.mjs'
export * from './precision.mjs'

export * from './auth.mjs'

const partialMatch = (
  existing,
  candidate,
  keys = Object.keys(candidate),
) => keys.reduce((acc, key) => {
  if (existing[key] === candidate[key])
    return true

  return false
}, false)

const dump = (...what) => what
  .map(x => JSON.stringify(x, null, 2))
  .map(json => console.log(json))

const crashDump = (...what) => {
  dump(...what)
  process.exit(-1)
}

const utils = {
  auth,
  dump,
  crashDump,
  Logger,
  precision,
  partialMatch,
}

export {
  utils as default,
  auth,
  dump,
  crashDump,
  Logger,
  precision,
  partialMatch,
}
