export const buildMessage = ({ from, iat, exp, lc, tz }) => {
  const accField = 'Address :'
  const accEntry = `${from.slice(0, 6)}...${from.slice(-6)}`

  const conField = 'Connection date :'
  const conEntry = new Date(iat).toLocaleString([lc], { timeZone: tz })

  const expField = 'Expiration date :'
  const expEntry = new Date(exp).toLocaleString([lc], { timeZone: tz })

  const mlf = Math.max(accField.length, conField.length, expField.length)
  const mle = Math.max(accEntry.length, conEntry.length, expEntry.length)

  const msg = `Sign the following message to authenticate. This will not result in any transaction.
    ${accField.padEnd(mlf + 5)} ${accEntry.padStart(mle + 2)}
    ${conField.padEnd(mlf + 5)} ${conEntry.padStart(mle + 2)}
    ${expField.padEnd(mlf + 5)} ${expEntry.padStart(mle + 2)}`

  return msg
}

export default {
  buildMessage,
}
