import { createHmac } from 'node:crypto'
import { spawn } from 'node:child_process'

import { sheriff as config } from '../config/config.mjs'

import Fastify from 'fastify'

const startTimestamp = Date.now()
const sheriff = Fastify({ logger: process.env.node_env === 'development' })

sheriff.get('/tip', async (req, res) => {
  res.send(startTimestamp)
})
sheriff.post('/tip', async (req, res) => {
  const [alg, H] = req.headers['x-hub-signature-256'].split('=')
  if (!H || !req.body || alg !== 'sha256')
    return req.raw.destroy()

  console.log({ H }, '<- Hook hit')

  const hmac = createHmac('sha256', config.hook)
    .update(JSON.stringify(req.body))
    .digest('hex')
  console.log('expected:', hmac)
  console.log('received:', H)

  if (hmac !== H)
    return res.status(401).send('Leave me be.')

  // const child = spawn('git', ['pull'])
  const command = 'git fetch origin && git reset --hard origin/master'
  const child = spawn(command, { shell: true })
  child.on('error', err => {
    res.status(500).send(err)
  })
  child.stdout.pipe(process.stdout)
  child.stderr.pipe(process.stderr)
  child.stdin.end()

  return res.status(200).send('OK')
})

sheriff.listen({
  port: config.port,
  host: config.host,
}, (err, addr) => {
  if (err)
    console.error(err)
  else
    console.log(`Sheriff up on ${addr}`)
})
