import crypto from 'crypto'
import { toQueryString } from '@remora/utils/queryString.mjs'

// const utf8 = str => Buffer.from(str).toString('utf-8')

export const sign = (blah, hush) => {
  const hash = crypto.createHash('sha256')
  // hash.update(utf8(blah))

  const dgst = hash.update(blah).digest()
  const secret = Buffer.from(hush, 'base64')
  const sig = crypto.createHmac('sha512', secret).update(dgst).digest('base64')

  return sig
}

export const authenticate = ({ apiKey, apiSecret, ...options }, endpoint) => {
  const { headers = {}, params, body } = options

  // const Nonce = Date.now()
  endpoint = endpoint.startsWith('/derivatives') ? endpoint.replace('/derivatives', '') : endpoint

  const reqData = '' +
      toQueryString(params) +
      (body || '') +
      // Nonce +
      endpoint

  const signature = sign(reqData, apiSecret)

  console.log({ reqData, signature, endpoint }, 'QSP ' + toQueryString(params), reqData)

  headers.APIKey = apiKey
  headers.Authent = signature
  // headers.Nonce = Nonce
  headers['Content-Length'] = body.length

  return {
    ...options,
    headers,
  }
}
