import assert from 'node:assert/strict'

import { test } from 'node:test'

import client from './client.mjs'

// import { writeFile } from 'node:fs/promises'

test('platforms.krk.client:get', _t => {
  return Promise.all([

    test('platforms.krk.client:get', async _t => {
      const response = await client.get('tickers', false)

      console.log(JSON.stringify(response))
      assert.strictEqual(response.result, 'success')

      return response
    }),

    test('platforms.krk.client:get:account', async _t => {
      const response = await client.get('accounts', true)
      console.log(JSON.stringify(response))

      const { result, ...data } = response
      assert.strictEqual(result, 'success')

      assert(data, 'No account data')

      // Dump for inspection
      // await Promise.all(
      //     Object.entries({ account, balances, positions })
      //         .map(([k, v]) =>
      //             // dump account data to file for debugging
      //             writeFile(`./_krk_${k}.fish`, JSON.stringify(v, null, 2))
      //                 .then(_ => v))
      // )
    }),

    // test('platforms.krk.client:get:balances', async t => {
    //     const balances = await client.get('balance', true)

    //     assert(balances)
    //     assert(balances.length)

    //     balances.forEach(b => {
    //         assert(b.asset)
    //         assert(b.balance)
    //         assert(b.crossWalletBalance)
    //         assert(b.availableBalance)
    //         assert(b.maxWithdrawAmount)
    //     })

    // }),

  ])
})

// test('platforms.krk.client:listenKey', t => {
//     return Promise.all([
//         test('platforms.krk.client:listenKey', async t => {
//             const res = await client.post('/fapi/v1/listenKey', true)

//             assert(res, `No res from post('/fapi/v1/listenKey')`)
//             assert(res.listenKey, `res.listenKey: ${res.listenKey}`)

//             const deleted = await client.delete('/fapi/v1/listenKey', {
//                 params: {
//                     listenKey: res.listenKey
//                 }
//             }, true)

//             assert.deepStrictEqual(deleted, {})
//         }),
//     ])
// })
