import crypto from 'crypto'

const getRequestParamString = param => {
  if (!param)
    return ''

  const map = new Map(Object.entries(param))
  const sortedMap = new Map([...map.entries()].sort())
  const params = new URLSearchParams()
  for (const [key, value] of sortedMap.entries())
    params.append(key, value || '')

  return params.toString()
}

export const sign = ({ reqTime, apiKey, apiSecret, requestParam }) => {
  const paramStr = getRequestParamString(requestParam)
  const targetStr = `${apiKey}${reqTime}${paramStr}`
  const signature = actualSignature(targetStr, apiSecret)

  return signature
}

const actualSignature = (inputStr, key) => {
  const hmac = crypto.createHmac('sha256', key)
  hmac.update(inputStr)
  return hmac.digest('hex')
}

export const generateHeaders = ({ apiKey, apiSecret, reqTime, method, queryParams, body }) => {
  const headers = {
    ApiKey: apiKey,
    'Request-Time': reqTime,
    'Content-Type': 'application/json',
  }

  let requestParam = ''
  if (method === 'POST' || method === 'PUT')
    requestParam = body
  else if (method === 'GET' || method === 'DELETE')
    requestParam = queryParams

  headers.Signature = sign({ reqTime, apiKey, apiSecret, requestParam })

  return headers
}
