const platform = 'ByBit'

const topics = {
  wallet: 'balances',
  position: 'positions',
}

const formatBalances = ({ creationTime: timestamp, data }) => {
  const account = data.find(acc => acc.accountType === 'UNIFIED')
  const balances = account.coin.reduce((acc, balance) => {
    // TODO : include other equity ? IDK
    if (balance.coin === 'USDT') {
      acc[balance.coin] = {
        lastUpdated: timestamp,
        available: Number(balance.availableToWithdraw) || (balance.walletBalance - balance.totalPositionIM),
        extraInfo: { ...balance },
      }
    }

    return acc
  }, {})

  const formatted = {
    timestamp,
    balances,
  }

  return ({
    type: 'account',
    data: formatted,
  })
}

const formatPositions = ({ creationTime: timestamp, data }) => {
  const positions = data.reduce((acc, position) => {
    const {
      symbol,
      size: quantity,
      avgPrice: entry,
      leverage,
      positionBalance: margin,
      updatedTime: lastUpdated,
    } = position

    return ({
      ...acc,
      [symbol]: {
        quantity,
        entry: entry || position.entryPrice,
        margin,
        leverage,
        lastUpdated,
        extraInfo: position,
      },
    })
  }, {})

  const formatted = {
    timestamp,
    positions,
  }

  return {
    type: 'account',
    data: formatted,
  }
}

export const match = msg => {
  // console.log(msg, `in:match ${platform}`)

  const handledBy = topics[msg.topic]
  if (!handledBy)
    return

  if (msg.event === 'subscribed') {
    console.info(`${platform} SUBSCRIBE ${msg.feed}`)
    return
  }

  if (!handlers[handledBy]) {
    console.warn(`${platform}::warn No handler for ${msg.feed}`)

    return
  }

  return handlers[handledBy]
}

const handlers = {
  balances: formatBalances,
  positions: formatPositions,
}

export default {
  match,
}
