import crypto from 'node:crypto'

export const sign = (blah, hush) => crypto
  .createHmac('sha256', hush)
  .update(blah)
  .digest('hex')

export const authenticate = ({ apiKey, apiSecret, options }, path) => {
  console.log({ path, options })
  const ts = Date.now()

  const headers = {
    'X-BAPI-API-KEY': apiKey,
    'X-BAPI-TIMESTAMP': ts,
  }

  let payload
  if (options.body)
    payload = JSON.stringify(options.body)
  else if (options.params)
    payload = new URLSearchParams(options.params).toString()
  else
    payload = ''

  const challenge = `${ts}${apiKey}${payload}`
  const sig = sign(challenge, apiSecret)

  headers['X-BAPI-SIGN'] = sig

  options = {
    ...options,
    headers: {
      ...options.headers,
      ...headers,
    },
  }
  if (options.body)
    options.body = payload

  return options
}
