const platform = 'Binance'

const collateralAssets = ['USDT']

const formatAccountInit = msg => {
  const { balances, positions } = msg
  const formatted = {}
  let latest = 0
  if (balances) {
  // TODO : Consider cross / multi-asset so other assets than USDT can be considered as collat
    formatted.balances = balances.filter(b => collateralAssets.includes(b.asset))
      .reduce((acc, balance) => {
        const {
          asset,
          availableBalance: available,
          updateTime: lastUpdated,
          crossWalletBalance: total,
        } = balance

        if (Number(lastUpdated) > latest)
          latest = lastUpdated
        return {
          ...acc,
          [asset]: {
            asset,
            total,
            available,
            lastUpdated,
            extraInfo: { ...balance },
          },
        }
      }, {})
  }

  if (positions) {
    formatted.positions = positions.filter(({ updateTime }) => Number(updateTime))
      .reduce((acc, position) => {
        const {
          symbol,
          notional,
          leverage,
          positionAmt: quantity,
          entryPrice: entry,
          isolatedMargin: margin,
          updateTime: lastUpdated,
        } = position

        if (Number(lastUpdated) > latest)
          latest = lastUpdated
        return {
          ...acc,
          [symbol]: {
            symbol,
            quantity,
            notional,
            entry,
            leverage,
            margin,
            lastUpdated,
            extraInfo: { ...position },
          },
        }
      }, {})
  }

  return ({
    type: 'account',
    data: {
      timestamp: latest,
      ...formatted,
    },
  })
}

const formatAccount = ({ T: transactionTime, E: eventTime, a: accountData, ...rest }) => {
  // const raw = { T: transactionTime, E: eventTime, a: accountData, ...rest }
  const timestamp = transactionTime || eventTime

  const formatted = { timestamp }

  const { B: balances } = accountData
  if (balances.length) {
    formatted.balances = balances.reduce((acc, raw) => {
      const {
        a: asset,
        wb: total,
        cw: available,
        // bc: change,
      } = raw

      if (collateralAssets.includes(asset)) {
        acc[asset] = {
          asset,
          total,
          available,
          lastUpdated: timestamp,
          extraInfo: raw,
        }
      }

      return acc
    }, {})
  }

  const { P: positions } = accountData
  if (positions.length) {
    formatted.positions = positions.reduce((acc, raw) => {
      const {
        s: symbol,
        pa: quantity,
        ep: entry,
        iw: margin,
      } = raw

      return ({
        ...acc,
        [symbol]: {
          quantity,
          entry,
          margin,
          lastUpdated: timestamp,
          extraInfo: raw,
        },
      })
    }, {})
  }

  return {
    type: 'account',
    data: formatted,
  }
}

const eventTypes = {
  ACCOUNT_INIT: 'accountInit',
  ACCOUNT_UPDATE: 'accountUpdate',
  ORDER_TRADE_UPDATE: undefined,
}

const notImplemented = msg => {
  const event = msg.eventType || msg.e

  console.log(`${platform}:${event} not implemented.`)
}

const handlers = {
  accountInit: formatAccountInit,
  accountUpdate: formatAccount,
  [undefined]: notImplemented,
}

export const match = msg => {
  // console.log(msg, `in:match ${platform}`)
  const event = msg.eventType || msg.e
  const handledBy = eventTypes[event]
  const handler = handlers[handledBy]

  if (handler !== notImplemented)
    return handlers[handledBy]

  return handler(msg)
}
export const translate = data => {
  const handler = match(data)

  return handler(data)
}

export default {
  match,
  translate,
}
