import crypto from 'node:crypto'
import { toQueryString } from '@remora/utils/queryString.mjs'

export const sign = (blah, hush) => {
  const signature = crypto.createHmac('sha256', hush)
  signature.update(blah)

  return signature.digest('hex')
}

// export const generateHeaders = ({ apiKey, apiSecret, reqTime, params, body }) => {
//   const headers = {
//     'X-MBX-APIKEY': apiKey,
//     'Request-Time': reqTime,
//     // 'Content-Type': 'application/json',
//   }
//
//   // const reqData = '' + toQueryString(params) + (body ? JSON.stringify(body) : '')
//   const reqData = '' + toQueryString(params) + (body ? JSON.stringify(body) : '')
//
//   headers.signature = sign(reqData, apiSecret)
//
//   return headers
// }

export const authenticate = ({ apiKey, apiSecret, ...options }) => {
  const { headers = {}, params, body } = options

  const reqData = '' +
    toQueryString(params) +
    (body || '')
  // (body ? JSON.stringify(body) : '')

  const signature = sign(reqData, apiSecret)

  headers['X-MBX-APIKEY'] = apiKey
  headers.signature = signature

  options.params = {
    ...options.params,
    signature,
  }

  return {
    ...options,
    headers,
  }
}
