import React, { lazy, Suspense } from 'react'
import ReactDOM from 'react-dom/client'

import './index.css'
import './App.css'

import {
  BrowserRouter,
  Routes,
  Route,
  Navigate,
} from 'react-router-dom'

import SymbolProvider from './providers/symbol'

import EthProvider from './providers/ethereum'
import AuthProvider from './providers/auth/auth'
import PositionsProvider from './providers/auth/positions'
import BalanceProvider from './providers/auth/balance'

import WebSocketProvider from './providers/webSocket'
import PricesProvider from './providers/webSocket/prices'

import Login from './components/Login'
import AppNav from './components/AppNav'
import { WithAuth } from './components/Conditional.jsx'

const TradeView = lazy(_ => import('./components/Trade/OrderBox.jsx'))
const Dashboard = lazy(_ => import('./components/Dashboard.jsx'))

function App () {
  return (
    <BrowserRouter>

      <EthProvider><AuthProvider><BalanceProvider><PositionsProvider>

        <WebSocketProvider><PricesProvider>

          <SymbolProvider>
            <div id='App'>
              <AppNav />
              <div id='Content' className='fullWidth fullHeight'>
                <Suspense>
                  <Routes>
                    <Route path='/trade' element={<Navigate to='./ETHfish' />} />
                    <Route path='/trade/:symbol' element={<TradeView />} />

                    <Route path='/fish' element={<Dashboard />} />
                    <Route path='/account' element={<Login />} />

                    <Route path='*' element={<WithAuth fallback={<Login />}><Navigate to='/trade' /></WithAuth>} />
                  </Routes>
                </Suspense>
              </div>
            </div>
          </SymbolProvider>

        </PricesProvider></WebSocketProvider>

      </PositionsProvider></BalanceProvider></AuthProvider></EthProvider>

    </BrowserRouter>
  )
}

window.reactRoot = window.reactRoot || ReactDOM.createRoot(document.getElementById('root'))
window.reactRoot.render(
  <React.StrictMode>
    <App />
  </React.StrictMode>,
)
