import {
  createContext, useContext,
  useEffect, useState,
} from 'react'

import { useWebSocket } from '../webSocket'

import { coin, toPair } from '../symbol.jsx'

const pricesContext = createContext(null)
const usePrices = _ => {
  const ctx = useContext(pricesContext)

  if (!ctx)
    throw new Error('useWebSocket must be used within a WebSocketProvider')

  return ctx
}

const translateSymbols = update => {
  if (!update)
    console.warn(update, 'update not entries thingy ?')

  return Object.entries(update).reduce((translated, [symbol, price]) => {
    symbol = toPair(coin(symbol))
    translated[symbol] = price
    return translated
  }, {})
}
const PricesProvider = ({ children }) => {
  const { on, off } = useWebSocket()
  const [prices, setPrices] = useState({})

  const updatePrices = update => setPrices(prev => {
    const state = {
      ...prev,
      ...update.prices,
    }

    return state
  })

  useEffect(_ => {
    const translatedUpdate = update => {
      if (update.prices) {
        const translated = translateSymbols(update.prices)
        updatePrices({ ...update, prices: translated })
      } else console.warn(update, 'No prices in update.')
    }

    on('prices', translatedUpdate)
    return _ => off('prices', translatedUpdate)
  }, [])

  return <pricesContext.Provider value={{ prices }}>
        {children}
    </pricesContext.Provider>
}

export {
  PricesProvider as default, PricesProvider as Provider,
  pricesContext, pricesContext as context,
  usePrices, usePrices as useProvider,
}
