import { useContext, useEffect, createContext, useState } from 'react'

import { useNavigate, useLocation, useParams } from 'react-router-dom'

const coins = [
  'BTC',
  'ETH',
]

const coin = pair => coins.find(c => pair.toUpperCase().startsWith(c))
const toPair = (coin, quote = 'fish') => coin + quote

const SymbolProvider = ({ children }) => {
  const [symbol, setSymbol] = useState('ETHfish')

  return <SymbolContext.Provider value={{ symbol, setSymbol, coin: coin(symbol) }}>
        {children}
    </SymbolContext.Provider>
}

const SymbolContext = createContext(null)
const useSymbol = _ => {
  const state = useContext(SymbolContext)

  if (!state)
    throw new Error('SymbolProvider not found')

  const { symbol } = useParams()
  const navigate = useNavigate()
  const { pathname } = useLocation()

  useEffect(_ => {
    if (symbol && symbol !== state.symbol) {
      const target = toPair(coin(symbol))

      if (symbol !== target)
        navigate(pathname.replace(symbol, target), { replace: true })
      if (state.symbol !== target)
        state.setSymbol(target)
    }
  }, [symbol])

  return state
}

export {
  SymbolProvider as default, SymbolProvider,
  SymbolContext,
  useSymbol,
  coins, coin, toPair,
}
