import {
  createContext,
  useContext,
  useState,
  useEffect,
} from 'react'

import detectProvider from '@metamask/detect-provider'

const requestAccounts = async provider => {
  if (!provider) return

  const eth = provider

  try {
    const accounts = await eth.request({ method: 'eth_requestAccounts' })
    return accounts.map(a => a.toLowerCase())
  } catch (e) {
    console.error(e)
    return []
  }
}

const getAccounts = async provider => {
  if (!provider) return []

  const eth = provider

  try {
    const accounts = await eth.request({ method: 'eth_accounts' })
    return accounts.map(a => a.toLowerCase())
  } catch (e) {
    console.error(e)
    return []
  }
}

const EthProvider = ({ children }) => {
  const [provider, setProvider] = useState(window.ethereum)
  const [account, setAccount] = useState()

  const handlers = {
    accountsChanged: accounts => {
      const [active] = accounts
      console.info('accountsChanged', active?.toLowerCase())
      setAccount(active?.toLowerCase())
    },
    connect: console.info,
    disconnect: console.info,
  }
  bindListeners(provider, handlers)

  const connect = async _ => {
    try {
      const accounts = await requestAccounts(provider)

      const [active] = accounts
      setAccount(active?.toLowerCase())
    } catch (e) {
      setAccount(null)
    }
  }

  const updateProvider = detected => {
    console.info('UPDATEPROVIDER CALLED')
    if (detected === provider) return

    if (detected) {
      alert('HALLO IS BINDLISTENER CALLED ?!!')
      bindListeners(detected, handlers)
    }

    if (provider)
      removeListeners(provider, handlers)

    // wat ? -> remove, provider effect should do acct stuff
    // if (activeAccount !== account)
    //   setAccount(activeAccount)

    setProvider(detected)
  }

  useEffect(_ => {
    const connected = getAccounts(provider)

    connected.then(([active]) => {
      setAccount(active?.toLowerCase())
    })
  }, [provider])

  useEffect(_ => {
    const aProvider = detectProvider()

    aProvider.then(candidate => {
      if (provider === candidate) return

      updateProvider(candidate)
    })

    return async _ => {
      const provider = await aProvider

      removeListeners(provider, handlers)
    }
  }, [])

  return <EthContext.Provider
        value={{
          eth: provider,
          account,
          connect,
        }}>
        {children}
    </EthContext.Provider>
}

const removeListeners = (provider, handlers) => {
  if (!provider)
    return

  if (!provider.off)
    provider.off = provider.removeListener

  Object.entries(handlers).forEach(([event, handler]) => {
    provider.off(event, handler)
  })
}

const bindListeners = (provider, handlers) => {
  if (!provider)
    return

  if (!provider.on)
    provider.on = provider.addListener

  Object.entries(handlers).forEach(([event, handler]) => {
    provider.on(event, handler)
  })
}
const EthContext = createContext(null)
const useEthereum = _ => useContext(EthContext)

export {
  EthProvider as default, EthProvider,
  EthContext,
  useEthereum,
}
