import {
  createContext, useContext,
  useEffect, useState,
} from 'react'

import { useApi } from '../../hooks/api.mjs'

const balanceContext = createContext(null)
const useBalance = _ => {
  const ctx = useContext(balanceContext)

  if (!ctx)
    throw new Error('useWebSocket must be used within a WebSocketProvider')

  return ctx
}

const BalanceProvider = ({ children }) => {
  const api = useApi()
  const [balance, setbalance] = useState(null)

  const updateBalance = update => setbalance(prev => {
    const state = {
      ...prev,
      ...update,
    }
    // console.info('updateBalance', prev, update, state)

    return state
  })

  useEffect(_ => {
    api.isAuth && api.balance().then(updateBalance)
  }, [api.isAuth])

  return <balanceContext.Provider value={{ balance, updateBalance }}>
        {children}
    </balanceContext.Provider>
}

export {
  BalanceProvider as default, BalanceProvider as Provider,
  balanceContext, balanceContext as context,
  useBalance, useBalance as useProvider,
}
