// TODO : This whole feature is shitly impled :D
import { useState, useEffect } from 'react'
import { useAuth } from '../providers/auth/auth'
import Conditional from './Conditional'
import { useApi } from '../hooks/api.mjs'
import Collapsible from './Collapsible'
import Login from './Login'

// TODO : RBAC in a proper / better place
const hasOneOf = (arr1, arr2) => arr1.some(item => arr2?.includes(item))

const Register = () => {
  return (
        <div>
            <h3>Register</h3>
            Coming Soon !
        </div>
  )
}

const Faucet = () => {
  return (
        <div>
            <h3>Faucet</h3>
            Coming Soon !
        </div>
  )
}

const Liquidity = ({ data }) => {
  const { balances, positions } = data || {}

  if (balances?.undefined) {
    console.error('Undefined balances', balances.undefined)
    delete balances.undefined
  }

  const freeMargin = Object.values(balances || {})
    .reduce((acc, bal) => acc + Number(bal.margin), 0)
  const lockedMargin = Object.values(positions || {})
    .reduce((acc, usr) => acc + Object.values(usr).reduce(
      (acc, sym) => acc + Number(sym.margin), 0,
    ), 0)

  const totalMargin = freeMargin + lockedMargin
  const freeRatio = (100 * freeMargin / totalMargin).toFixed(2)

  const DataRow = ({ title, value }) => {
    return <tr>
        <td>{title} : </td>
        <td className='mono'>{value}</td>
      </tr>
  }
  return (
        <Collapsible title={<h3>Liquidity</h3>} open>
        <Conditional
            check={Object.keys(data).length > 0}
            fallback={<div>Loading...</div>}>

            <table><tbody>
              <DataRow title="Free Margin" value={freeMargin} />
              <DataRow title="Locked Margin" value={lockedMargin} />
              <DataRow title="Ratio" value={`${freeRatio}%`} />
              <DataRow title="Total Margin" value={totalMargin} />
            </tbody></table>
        </Conditional>
        </Collapsible>
  )
}

const RemoraState = ({ data }) => {
  if (!data) return <div>Error connecting to Remora.</div>

  return (
      <Collapsible title={<h3>State</h3>} open>
      <Conditional
          check={Object.keys(data).length > 0}
          fallback={<div>Loading...</div>}>

          {Object.keys(data).map(key => {
            return <Collapsible key={key} title={key}>
              { key === 'platforms'
                ? <PlatformsData platforms={data[key]} />
                : <pre>{JSON.stringify(data[key], null, 2)}</pre>
              } </Collapsible>
          })}
      </Conditional>
      </Collapsible>
  )
}

const PlatformsData = ({ platforms }) => {
  if (!platforms) return <div>Error connecting to Remora.</div>

  const PlatformState = ({ name, state, open = true }) => <Collapsible title={name} open={open}>
    <pre>{JSON.stringify(state, null, 2)}</pre>
  </Collapsible>

  return (
      <Conditional
          check={Object.keys(platforms).length > 0}
          fallback={<div>Loading...</div>}>

          <div className='space-between'>
            {Object.keys(platforms)
              // .filter(pf => pf !== 'remora')
              .sort()
              .map(pfName => {
                return <div className='flex' key={pfName}>
                  <PlatformState name={pfName} state={platforms[pfName]} />
                </div>
              })}
          </div>
      </Conditional>
  )
}

const Prices = ({ data, routing }) => {
  if (!data) return <div>Error connecting to Remora.</div>

  const PlatformPrices = ({ name, prices, open = true, children }) => <Collapsible title={name} open={open}>
    <div className={'flex-row space-between'}>
      <pre className={'flex'}>{JSON.stringify(prices, null, 2)}</pre>
      {children}
    </div>
  </Collapsible>

  return (
      <Collapsible title={<h3>Prices</h3>} open>
      <Conditional
          check={Object.keys(data).length > 0}
          fallback={<div>Loading...</div>}>

          <div className='space-between'>
            {Object.entries(data.externals || {})
              .sort(([_1, data1], [_2, data2]) => Number(data2.ETHUSDT?.ask) - Number(data1.ETHUSDT?.ask))
              .map(([pf, data]) => {
                return <div className='flex' key={pf}>
                  <PlatformPrices name={pf} prices={data} />
                </div>
              })}
          </div>
          <PlatformPrices name='remora' prices={data.remora}>
            { Object.entries(routing).map(([symbol, routes]) =>
              <pre className={'space-between'} key={`routes-${symbol}`}>
                {JSON.stringify({ [symbol]: routes }, null, 2) }
              </pre>)
            }
          </PlatformPrices>
      </Conditional>
      </Collapsible>
  )
}

const roleChecks = {
  faucet: ['user', 'test', 'admin', 'owner'],
  // liquidity: ['admin', 'owner'],
}

const stateRoles = ['admin', 'owner', 'test']

const Dashboard = () => {
  const [data, setData] = useState({})
  const [prices, setPrices] = useState({})
  const [routing, setRouting] = useState({})

  const { auth } = useAuth()
  const { usr: user } = auth || {}

  const api = useApi()
  const fetchRemoState = _ => {
    if (!hasOneOf(stateRoles, user?.rol)) return

    api.authRequest('/state')
      .then(result => {
        if (!result) return

        setData(result)
      })
      .catch(console.error)
  }
  const fetchPrices = _ => {
    api.authRequest('/prices')
      .then(result => {
        if (!result) return

        setPrices(result)
      })
      .catch(console.error)
  }
  const fetchRouting = _ => {
    api.authRequest('/routing')
      .then(result => {
        if (!result) return

        setRouting(result)
      })
      .catch(console.error)
  }
  const refreshData = _ => {
    if (!auth) return

    fetchRemoState()
    fetchPrices()
    fetchRouting()
  }

  useEffect(() => {
    if (!auth)
      return

    refreshData()
  }, [auth])

  useEffect(_ => {
    window.addEventListener('visibilitychange', refreshData)
    window.addEventListener('focus', refreshData)

    return _ => {
      window.removeEventListener('visibilitychange', refreshData)
      window.removeEventListener('focus', refreshData)
    }
  }, [])

  return (
        <div>
            <h2>Dashboard</h2>
            <Conditional check={user?.rol} fallback={<Login />}>

                <Conditional check={!user?.rol.length}>
                    <Register />
                </Conditional>

                <Conditional check={hasOneOf(roleChecks.faucet, user?.rol)}>
                    <Faucet />
                </Conditional>

                <Conditional check={hasOneOf(stateRoles, user?.rol)}>
                    <Liquidity data={data} />
                </Conditional>

                <Conditional check={hasOneOf(stateRoles, user?.rol)}>
                    <RemoraState data={data} />
                </Conditional>

                <Conditional check={hasOneOf(stateRoles, user?.rol)}>
                    <Prices data={prices} routing={routing} />
                </Conditional>

                <Conditional check={hasOneOf(stateRoles, user?.rol)}>
                    <button className='sticky bottom right' onClick={refreshData}>Update data</button>
                </Conditional>

            </Conditional>
        </div>
  )
}

export default Dashboard
