import { useAuth } from '../providers/auth/auth.jsx'

const Conditional = ({ check, children, fallback }) => check
  ? children
  : fallback

export const WithAuth = ({ children, fallback }) => {
  const { auth } = useAuth()

  return <Conditional check={auth} fallback={fallback}>
        {children}
    </Conditional>
}

export default Conditional
