import { useState } from 'react'

const Collapsible = ({ children, title, open, extraControls }) => {
  const [closed, setClosed] = useState(!open)
  const toggleOpen = _ => setClosed(!closed)
  open = !closed

  const Controls = _ => <span className='noselect mono'>
        {extraControls}
        <Expand />
    </span>

  const Expand = _ => <span onClick={toggleOpen}>{
        open
          ? '[hide v]'
          : '[show <]'}
    </span>

  return <div className='collapsible nomb smallmt'>
        <div className='accented fullWidth nomargin noselect flex space-between' onClick={toggleOpen}>
            <span>{title}</span><Controls />
        </div>

        {open && children}
    </div>
}

export default Collapsible
