import connection from '@remora/api/data/db.mjs'

const db = await connection

const changes = {}
const duplicates = []
const lastBalance = {
  '0x7cd974d9ce1014a3feb5f359c5d9b83174209782': 0,
}

console.log(await db.collection('sequences').find().forEach(seq => {
  const {
    action: { from: id },
    diff: {
      balances: {
        [id]: { margin: marginDiff },
      },
    },
    result,
  } = seq

  const { _id, ...sequence } = seq
  const { margin } = sequence.result.balances[id]
  if (margin === lastBalance[id]) {
    duplicates.push(seq)
    return
  }

  lastBalance[id] = margin

  if (!changes[id])
    changes[id] = { count: 0, diff: 0 }

  ++changes[id].count
  changes[id].diff += Number(marginDiff)

  console.log(result.balances)
}))

console.log(JSON.stringify(changes, null, 2))
