import crypto from 'node:crypto'

const KRAKEN_API_KEY = ''
const KRAKEN_API_SECRET = ''

const baseUrl = 'https://api.futures.kraken.com/derivatives'
const endpoint = '/api/v3/sendorder'

const nonce = Date.now()
const payload = {
  orderType: 'mkt',
  side: 'sell',
  size: 0.01,
  symbol: 'PF_ETHUSD',
}
const query = Object
  .keys(payload)
  .sort()
  .map(k =>
    `${k}=${payload[k]}`)
  .join('&')
console.log(query)

const secret = Buffer.from(KRAKEN_API_SECRET, 'base64')

const hash = crypto.createHash('sha256').update(query + nonce + endpoint.toLowerCase()).digest()
const hmac = crypto.createHmac('sha512', secret).update(hash).digest()

const sig = hmac.toString('base64')

const headers = {
  APIKey: KRAKEN_API_KEY,
  Nonce: nonce,
  Authent: sig,
}

const url = `${baseUrl}${endpoint}?${query}`
console.log(headers, url)

fetch(url, {
  headers,
  method: 'POST',
  body: query,
  // method: 'GET',
}).then(x => x.json())
  .then(console.log)
