import crypto from 'node:crypto'

const url = 'https://api.bybit.com'

const apiKey = ''
const secret = ''
const timestamp = Date.now().toString()

const sign = payload => crypto
  .createHmac('sha256', secret)
  .update(payload)
  .digest('hex')

const query = 'accountType=CONTRACT'

const headers = {
  // 'X-BAPI-SIGN-TYPE': '2',
  // 'X-BAPI-SIGN': sign,
  'X-BAPI-API-KEY': apiKey,
  'X-BAPI-TIMESTAMP': timestamp,
  // 'X-BAPI-RECV-WINDOW': recvWindow.toString(),
}

const data = `${timestamp}${apiKey}${query}`

fetch(`${url}/v5/account/wallet-balance?${query}`, {
  method: 'GET',
  headers: {
    ...headers,
    'X-BAPI-SIGN': sign(data),
  },
}).then(res => res.json())
  .then(console.log)
