import WebSocket from 'ws'

const ws = new WebSocket('wss://fstream.binance.com/ws')
ws.on = (...args) => ws.addEventListener(...args)
ws.on('message', msg => console.log(JSON.parse(msg.data)))
ws.on('error', err => console.error(err))
ws.on('close', (...args) => console.log('CLOSE', ...args))
ws.on('open', _ => {
  console.log('OPEN')
  const payload = {
    method: 'SUBSCRIBE',
    params: [
      'ethusdt@depth20@100ms',
    ],
  }
  ws.send(JSON.stringify(payload))
})
