# pull official base image
FROM node:18.16.0-alpine

RUN apk --update add git openssh

USER node

RUN mkdir -p ~/.ssh
RUN ssh-keyscan github.com >> ~/.ssh/known_hosts
RUN git config --global --add safe.directory /remora

# set working directory
WORKDIR /remora/sheriff

# install app dependencies
#copies package.json and package-lock.json to Docker environment
COPY package.json .

# Installs all node packages
RUN npm i

# Copies everything over to Docker environment
COPY . ./

EXPOSE 8778

ENTRYPOINT ["npm", "dev"]
