const envToLogger = {
  development: {
    transport: {
      target: 'pino-pretty',
      options: {
        translateTime: 'HH:MM:ss Z',
        ignore: 'pid,hostname',
      },
    },
  },
  production: true,
  test: false,
}
const apiLogger = envToLogger[process.env.NODE_ENV] || envToLogger.development

export const api = {
  port: process.env.API_LISTEN_PORT || 8778,
  host: process.env.API_LISTEN_HOST || 'localhost',
  logger: apiLogger,
  trustProxy: process.env.API_TRUST_PROXY === 'true' ? true : process.env.API_TRUST_PROXY,
}
export const platforms = {
  bnb: {
    name: 'Binance',
    apiKey: process.env.BINANCE_API_KEY,
    apiSecret: process.env.BINANCE_API_SECRET,
    baseUrl: process.env.BINANCE_API_URL || 'https://testnet.binancefuture.com',
    wsUrl: process.env.BINANCE_WS_URL || 'wss://fstream.binancefuture.com/ws',
  },
  krk: {
    name: 'Kraken',
    apiKey: process.env.KRAKEN_API_KEY,
    apiSecret: process.env.KRAKEN_API_SECRET,
    baseUrl: process.env.KRAKEN_API_URL || 'https://demo-futures.kraken.com/derivatives/api/v3/',
    wsUrl: process.env.KRAKEN_WS_URL || 'wss://api.futures.kraken.com/ws/v1',
  },
  byb: {
    name: 'ByBit',
    apiKey: process.env.BYBIT_API_KEY,
    apiSecret: process.env.BYBIT_API_SECRET,
    baseUrl: process.env.BYBIT_API_URL || 'https://api-testnet.bybit.com',
    wsUrl: process.env.BYBIT_WS_URL || 'wss://stream-testnet.bybit.com',
  },
}
export const sheriff = {
  port: process.env.SHERIFF_LISTEN_PORT || 6667,
  host: process.env.SHERIFF_LISTEN_HOST || 'localhost',
  hook: process.env.SHERIFF_SECRET_HOOK || '',
}

export const relay = {
  socket: {
    host: process.env.RELAY_HOST || 'localhost',
    port: process.env.RELAY_PORT || 6379,
    family: 4,
  },
}

export default {
  api,
  platforms,
  relay,
  sheriff,
}
