import test from 'node:test'
import assert from 'node:assert/strict'

import users, {
  getUser,
  get,
  getRoles,
  // apply,
  assign,
} from './users.mjs'
// import actions from '../engine/actions/users.mjs'

test('state.users', _ => {
  return Promise.all([
    test('state.users:init', _ => {
      const initState = {
        '0x1': {
          uid: 0x01,
          nic: 'test',
          rol: ['user'],
        },
      }
      assert.deepStrictEqual(
        users.init(initState),
        initState,
        'users.init() returns expected data',
      )

      assert.deepStrictEqual(
        users.get(),
        { '0x1': { uid: 0x01, nic: 'test', rol: ['user'] } },
        'users.get() returns init data')

      assert.deepStrictEqual(
        users.get('0x1'),
        { uid: 0x01, nic: 'test', rol: ['user'] },
        'users.get("0x1") returns expected user')
    }),

    test('state.users:getRoles', _ => {
      assert.deepStrictEqual(users.role('0x1'), ['user'], 'users.role("0x1") returns roles ["user"]')
      assert.deepStrictEqual(users.role('0x0'), [], 'users.role returns roles [] for unknown user')
    }),

    test('state.users:exports', _ => {
      assert.strictEqual(typeof getUser, 'function', 'getUser is exported')
      assert.strictEqual(typeof get, 'function', 'get is exported')
      assert.strictEqual(typeof getRoles, 'function', 'getRole is exported')
      // assert.strictEqual(typeof apply, 'function', 'apply is exported')
      assert.strictEqual(typeof assign, 'function', 'assign is exported')

      assert.strictEqual(get, users.get, 'get is exported as defaults.get')
      assert.strictEqual(getRoles, users.role, 'getRole is exported as defaults.role')
      // assert.strictEqual(apply, users.apply, 'apply is exported as defaults.apply')
      assert.strictEqual(assign, users.assign, 'assign is exported as defaults.assign')
    }),

  ])
})
