import { users } from '../data/seed.mjs'

// import { applyAction } from '../engine/sequence.mjs'

let state = structuredClone(users)

export const init = data => {
  state = structuredClone(data)
  return state
}

export const dumpState = prefix => {
  const dump = JSON.stringify(state)

  console.log(prefix, dump)
  return dump
}

export const getUser = address => state[address.toLowerCase()] || null

export const get = address => address
  ? getUser(address)
  : state
export const getUsers = get

export const getRoles = address => getUser(address)?.rol || []
// export const hasRole = (address, role) => getRoles(address).includes(role)
export const hasOneOfRoles = (address, roles) => {
  const uRoles = getRoles(address)
  return roles.some(r => uRoles.includes(r))
}

// export const apply = action => state = applyAction(state, action)

export const assign = (address, mut) => {
  if (!address) return Object.assign(state, mut)

  return Object.assign(state[address.toLowerCase()], mut)
}

export default {
  dumpState,
  get,
  role: getRoles,
  assign,
  init,
}
