import { fixNumber, fixPrice } from '@remora/utils'

export const computeRouting = (books, accounts) => {
  const paths = Object.entries(books).reduce((paths, [symbol, book]) => {
    const prices = {
      ask: {
        best: book.asks.at(0),
        worst: book.asks.at(-1),
      },
      bid: {
        best: book.bids.at(0),
        worst: book.bids.at(-1),
      },
    }

    const overlap = prices.bid.best[0] - prices.ask.best[0]
    const spread = prices.ask.worst[0] - prices.bid.worst[0]
    // const range = Math.max(spread, overlap)
    const range = Math.max(overlap, spread)

    const capacities = Object.entries(accounts).reduce((caps, [pf, account]) => {
      const available = Object.values(account.balances).reduce((total, asset) => +asset.available + total, 0)
      const openQty = +account.positions[symbol]?.quantity || 0

      const [ask, askRaw] = book.asks.find(([_real, _raw, _pf]) => _pf === pf)
      const [bid, bidRaw] = book.bids.find(([_real, _raw, _pf]) => _pf === pf)

      // TODO : lvg-agnostic
      const canOrder = {
        long: available + (openQty < 0 ? Math.abs(openQty) * ask / 50 : 0),
        short: available + (openQty > 0 ? openQty * ask / 50 : 0),
      }

      const ratios = {
        // long: canOrder.long / (canOrder.long + canOrder.short),
        // short: canOrder.short / (canOrder.long + canOrder.short),
        long: canOrder.long / Math.max(canOrder.long, canOrder.short),
        short: canOrder.short / Math.max(canOrder.long, canOrder.short),
      }

      const offset = {
        // ask: range - ratios.long * range,
        // bid: range - ratios.short * range,
        ask: range - ratios.long * range,
        bid: range - ratios.short * range,
      }

      const offsetPrices = {
        ask: fixPrice(+ask + offset.ask, symbol, Math.ceil),
        bid: fixPrice(+bid - offset.bid, symbol, Math.floor),
      }
      // TODO - per-plat price tick
      // if (pf === 'krk' && symbol === 'ETHUSDT') {
      //   offsetPrices.ask = fixNumber(+offsetPrices.ask, -1, Math.ceil)
      //   offsetPrices.bid = fixNumber(+offsetPrices.bid, -1, Math.floor)
      // }

      // if (pf === 'krk' && symbol === 'BTCUSDT') {
      //   offsetPrices.ask = fixNumber(+offsetPrices.ask, 0, Math.ceil)
      //   offsetPrices.bid = fixNumber(+offsetPrices.bid, 0, Math.floor)
      // }
      //       [range, ratios.short, ratios.long].forEach(n => {
      //         if (Number.isNaN(n)) {
      //           crashDump({
      //             range,
      //             ratios,
      //           })
      //         }
      //       })

      const capacity = {
        pf,
        symbol,
        available,
        openQty,
        range,
        canOrder,
        ratios,
        ask: {
          offset: offsetPrices.ask,
          real: ask,
          raw: askRaw,
        },
        bid: {
          offset: offsetPrices.bid,
          real: bid,
          raw: bidRaw,
        },
        offset,
      }

      return ([
        ...caps,
        capacity,
      ])
    }, [])

    return {
      ...paths,
      [symbol]: capacities,
    }
  }, {})

  return paths
}
