import {
  fixQty, fixQuote,
  // fromBig, toBig
} from '@remora/utils/precision.mjs'

import { positions } from '../data/seed.mjs'

const empty = {
  quantity: 0,
  notional: 0,
  margin: 0,
}

export const clearPosition = (address, symbol) => {
  const position = { ...empty }

  if (!address || !symbol)
    return position

  if (!positions[address])
    positions[address] = { [symbol]: position }
  else
    positions[address][symbol] = position

  return position
}

export const getPositions = account => {
  if (!account)
    return positions

  return positions[account]
}

export const marginDiff = ({ from, symbol, exec }) => {
  console.log({ in: 'marginDiff', from, symbol, exec })

  const {
    amount,
    side,
    price,
    leverage = 50,
  } = exec

  if (!amount) {
    const diff = {}
    console.log({ in: 'marginDiff::noAmount', diff })
    return diff
  }

  const position = positions[from]?.[symbol] || clearPosition(from, symbol)
  const positionSign = position.quantity
    ? position.quantity / Math.abs(position.quantity)
    : 0
  const positionQty = position.quantity * positionSign

  const maxQuote = amount * leverage
  const xQty = fixQty(maxQuote / price, symbol, Math.floor)
  const xSign = side === 'buy' ? 1 : -1

  if (!positionQty) {
    const qty = xQty
    const notional = qty * price
    const margin = fixQuote(qty * price / leverage, symbol, Math.ceil)
    const diff = {
      open: {
        quantity: xQty * xSign,
        margin,
        notional,
      },
    }
    console.log({ in: 'marginDiff::noPosition', diff })
    return diff
  }

  const closing = positionSign !== xSign
    ? Math.min(positionQty, xQty)
    : 0
  const opening = xQty - closing

  const diff = {}

  console.log({
    in: 'marginDiff::diffing',
    opening,
    closing,
    position,
    positionSign,
    exec,
    xSign,
    positionQty,
    xQty,
  })

  if (closing) {
    const notional = closing * position.notional / positionQty
    const value = closing * price

    if (closing === positionQty) {
      diff.close = { ...position }
      console.log({ in: 'marginDiff::closing::all', diff })
    } else {
      diff.close = {
        quantity: fixQty(closing, symbol) * positionSign,
        notional,
        margin: fixQuote(notional / leverage, symbol),
      }
    }

    const delta = value - notional
    diff.pnl = fixQuote(delta * positionSign, symbol, delta > 0 ? Math.floor : Math.ceil)
  }

  if (opening) {
    const notional = opening * price
    const margin = fixQuote(notional / leverage, symbol, Math.ceil)

    diff.open = {
      quantity: fixQty(opening, symbol) * xSign,
      notional,
      margin,
    }
  }

  console.log({
    in: 'marginDiff',
    from,
    symbol,
    exec,
    position,
    diff,
  })

  console.log({
    in: 'marginDiff::result',
    opening: diff.open && {
      quantity: diff.open.quantity,
      margin: diff.open.margin,
      notional: diff.open.notional,
    },
    closing: diff.close && {
      quantity: diff.close.quantity,
      margin: diff.close.margin,
      notional: diff.close.notional,
    },
  })

  return diff
}

export const patch = (diff, state = positions) => Object.keys(diff).reduce((update, user) => {
  return {
    ...update,
    [user]: Object.keys(diff[user]).reduce((positions, symbol) => {
      const position = positions[symbol] || { ...empty }
      const { quantity, notional, margin } = {
        ...empty,
        ...diff[user][symbol],
      }

      const next = {
        ...position,
        quantity: fixQty(+position.quantity + +quantity, symbol),
        notional: fixQuote(+position.notional + +notional, symbol),
        margin: fixQuote(+position.margin + +margin, symbol),
      }

      if (!Number(next.quantity)) {
        if (Number(next.notional))
          next.notional = 0
        if (Number(next.margin) && Number(next.margin) > 0)
          next.margin = 0
      }

      return {
        ...positions,
        [symbol]: next,
      }
    }, state?.[user] || {}),
  }
}, {})

const update = data => Object.keys(data).reduce((result, user) => {
  if (!positions[user])
    positions[user] = {}

  return ({
    ...result,
    [user]: Object.assign(positions[user], data[user]),
  })
}, {})

const init = data => Object.assign(positions, data)

export default {
  get: getPositions,
  diff: marginDiff,
  init,
  patch,
  update,
}
