import { platforms } from '../data/seed.mjs'

const init = data => Object.assign(platforms, data)

export const getAccounts = pf => {
  if (!pf)
    return platforms

  return platforms[pf]
}

// TODO return diff
export const update = (platform, update) => {
  // console.info(JSON.stringify({ platform, prev: platforms[platform], update }, null, 2), 'platforms::update')

  if (!update)
    throw new Error(`Can't update ${platform} with ${update}`)

  if (!platforms[platform]) {
    platforms[platform] = {
      lastUpdated: 0,
      balances: {},
      positions: {},
    }
  }

  Object.entries(update.balances || {}).forEach(([asset, balance]) => {
    const local = platforms[platform].balances[asset] || {}

    if (local.lastUpdated > balance.lastUpdated)
      return

    platforms[platform].balances[asset] = balance
  })

  if (update.positions) {
    if (platform === 'krk')
      platforms[platform].positions = update.positions
    else {
      Object.entries(update.positions).forEach(([symbol, position]) => {
        platforms[platform].positions[symbol] = position
      })
    }
  }

  if (update.timestamp > platforms[platform].lastUpdated)
    platforms[platform].lastUpdated = update.timestamp
}

export default {
  get: getAccounts,
  init,
  update,
}
