import { initState as localSync } from '../data/db.mjs'

import users, {
  getUser, getUsers,
  getRoles,
} from './users.mjs'

import books, {
  getBooks,
  updateBooks,
} from './books.mjs'

import balances, {
  getBalances,
} from './balances.mjs'

import positions, {
  getPositions,
} from './positions.mjs'

import platforms, {
  getAccounts,
  update as updateAccount,
} from './platforms.mjs'

const store = {
  users,
  books,
  balances,
  positions,
  platforms,
}

export const getState = (key, ...entries) => {
  const result = {}

  if (entries.length) {
    entries.forEach(entry => {
      result[entry] = store[entry].get(key)
    })

    return result
  }

  return ({
    users: getUsers(),
    books: getBooks(),
    balances: getBalances(),
    positions: getPositions(),
    platforms: getAccounts(),
  })
}

const seed = getState()
const local = await localSync(seed)

Object.entries(store).forEach(([k, resource]) => {
  resource.init(local[k])
})

const patch = data => Object.keys(data).reduce((update, k) => {
  update[k] = store[k].patch(data[k])

  return update
}, data)

const update = data => Object.keys(data).reduce((result, k) => {
  result[k] = store[k].update(data[k])

  return result
}, data)
//
// const subscribed = []
// const subscribe = listener => subscribed.push(listener)
// const onUpdate = _ => {
//   const state = getState()
//
//   subscribed.forEach(listener => listener(state))
// }

export default {
  ...store,
  get: getState,
  getAccounts,
  getBalances,
  getBooks,
  getPositions,
  getRoles,
  getState,
  getUser,
  getUsers,
  updateAccount,
  updateBooks,
  patch,
  update,
  // subscribe,
}
