import { fixPrice } from '@remora/utils/precision.mjs'
// import { getAccounts } from './platforms.mjs'

// export const STALE_MS = 1200

const fees = {
  bnb: {
    // maker: 0.0002,
    maker: 0.00018, // BNB discount 10%
    // maker: 0.000155, // T1: 25BNB + discount 10%
    // taker: 0.0005,
    taker: 0.00045, // BNB discount 10%
    // taker: 0.00036, // T1: 25BNB + discount 10%
  },
  byb: {
    maker: 0.00018, // VIP1: 10M volume or balance >100K
    // maker: 0.00016, // VIP2: 25M volume or balance >250K
    // taker: 0.00055,
    taker: 0.0004, // VIP1: 10M volume or balance >100K
    // taker: 0.000375, // VIP2: 25M volume or balance >250K
  },
  kcs: {
    //   // maker: 0.0002,
    maker: 0.000165, // KCS 17.5% off
    // maker: 0.0000825, // HODL 20k KCS ($200K), or 1K BTC volume + KCS 17,5 off
    //   // taker: 0.0006,
    taker: 0.000495, // KCS 17.5% off
    // taker: 0.0004125, // HODL 20k KCS ($200K), or 1K BTC volume + KCS 17,5 off
  },
  krk: {
    // KFEE 100%
    // maker: 0,
    // taker: 0,
    maker: 0.00004,
    taker: 0.00002,
    // maker: 0.0002,
    /* maker: 0.00015, // Volume >100K */
    // maker: 0.000125, // Volume >1M
    // maker: 0.0001, // Volume >5M
    // maker: 0.000075, // Volume >10M
    // taker: 0.0005,
    /* taker: 0.0004, // Volume >100K */
    // taker: 0.0003, // Volume >1M
    // taker: 0.00025, // Volume >5M
    // taker: 0.0002, // Volume >10M
    // multi: 0.0005,
    // collat: 'USD',
  },
}

const REMO_COLLAT = 'FISH'

const books = {
  remora: {
    BTCUSDT: {
      asks: [],
      bids: [],
    },
    ETHUSDT: {
      asks: [],
      bids: [],
    },
  },
}
const symbols = Object.keys(books.remora)

export const getBook = (platform, symbol) => {
  if (!books[platform])
    books[platform] = {}

  if (!symbol)
    return books[platform]

  if (!books[platform][symbol]) {
    for (const symbol of symbols) {
      if (!books[platform][symbol]) {
        books[platform][symbol] = {
          asks: [],
          bids: [],
        }
      }
    }
  }

  return books[platform][symbol]
}
export const getBooks = platform => {
  if (!platform)
    return books

  // return getBook(platform, depth)
  return getBook(platform)
}

export const updateBooks = (platform, symbol, update) => {
  platform ||= update.platform

  if (!platform)
    throw new Error('No platform specified for book update')

  symbol ||= update.symbol
  if (!symbol)
    throw new Error('No symbol specified for book update')

  // const start = Date.now()
  if (!books[platform])
    books[platform] = {}

  if (!books[platform][symbol] || !update.partial) {
    books[platform][symbol] = update

    if (platform !== 'kcs' && platform !== 'bnb')
      console.log('SNAPSHOT', platform, symbol)
  } else {
    const { asks: newAsks, bids: newBids, ...meta } = update
    if (!meta.timestamp)
      console.log('NO timestamp', platform, symbol, meta)
    const { asks: oldAsks, bids: oldBids } = books[platform][symbol]

    const [bestBid] = newBids.find(([_, q]) => +q !== 0) || oldBids[0] || [0]
    const [bestAsk] = newAsks.find(([_, q]) => +q !== 0) || oldAsks[0] || [Infinity]

    const asks = [...oldAsks, ...newAsks]
      .sort(([a], [b]) => a - b)
      .filter(([p]) => p - bestBid > 0)
      .filter(noNulled)
      .slice(0, 50)

    const bids = [...oldBids, ...newBids]
      .sort(([a], [b]) => b - a)
      .filter(([p]) => bestAsk - p > 0)
      .filter(noNulled)
      .slice(0, 50)

    books[platform][symbol] = {
      asks,
      bids,
      ...meta,
    }
  }

  if (!platform || !Object.keys(fees).includes(platform)) {
    console.error(symbol, update, `Invalid platform ${platform} for book update`)
    process.exit(-1)
  }
  return updateRemora(platform, symbol, books[platform][symbol])
}

export const applyFees = ({ price, pf, side }) => {
  const sides = {
    1: ['long', 'ask', 'asks'],
    '-1': ['short', 'bid', 'bids'],
  }
  if (!Object.values(sides).flat().includes(side)) {
    console.error({
      price, pf, side,
    })
    throw new Error(`Invalid side ${side} ${pf} ${price} : should be one of ['asks', 'bids'])`)
  }

  const sign = Object.keys(sides)
    .find(dir => sides[dir].includes(side))
  const postFee = +price + (sign * price * fees[pf].taker)

  // Conversion fee for multi collat --
  if (fees[pf].collat && fees[pf].collat !== REMO_COLLAT)
    return postFee + (sign * postFee * fees[pf].multi)

  return postFee
}

// TODO : Cache remora prices, update one pf at a time ?
const updateRemora = (platform, symbol, update) => {
  const changes = Object.entries(update).reduce((changes, [side, entries]) => {
    // node : skips metadata ?
    if (!['asks', 'bids'].includes(side))
      return changes

    if (!entries.length)
      return changes

    const sign = side === 'asks' ? 1 : -1

    const [price] = entries[0]
    const postFee = applyFees({ price, pf: platform, side })

    const fixedPrice = fixPrice(postFee, symbol, side === 'asks'
      ? Math.ceil
      : Math.floor)
    if (fixedPrice === 'NaN') {
      console.error({ price, postFee, fixedPrice, symbol, side })
      throw new Error(`Invalid price ${price} ${postFee} ${fixedPrice} ${symbol} ${side}`)
    }

    const candidate = [fixedPrice, price, platform]

    const remoraSide = books.remora[symbol]?.[side] || []
    const updatedSide = [
      ...remoraSide.filter(([_p, _q, pf]) => pf !== platform),
      candidate,
    ].sort(([a], [b]) => sign * (a - b))
    return ({
      ...changes,
      [side]: updatedSide,
    })
  }, {})

  if (!Object.keys(changes).length)
    return

  books.remora = {
    ...books.remora,
    [symbol]: {
      ...books.remora[symbol],
      // ...changes[symbol],
      ...changes,
    },
  }

  // return changes
  return books.remora
}

const noNulled = ([price, qty], i, all) => {
  if (+qty === 0)
    return false

  const [nextPrice, nextQty] = all[i + 1] || []

  return !(nextPrice && +nextPrice === +price && +nextQty === 0)
}

export const getPrices = (source = 'remora', symbol, side) => {
  const book = books[source]
  if (!book)
    return null

  if (symbol) {
    if (!book[symbol]) {
      book[symbol] = {
        asks: [],
        bids: [],
      }
    }
    const { asks = [], bids = [] } = book[symbol]

    const [bestAsk] = asks[0] || [0]
    const [bestBid] = bids[0] || [0]

    if (['ask', 'bid'].includes(side)) {
      const { [side]: price } = {
        ask: bestAsk, bid: bestBid,
      }
      return price
    }

    return {
      ask: bestAsk,
      bid: bestBid,
      T: Date.now(),
    }
  }
}

export default {
  getBooks,
  getBook,
  updateBooks,
  getPrices,
  init: state => Object.assign(books, state.books),
}
