// Balances.
// Remora : per-platform, total / long / short
// per-user: balances on remora, total / long / short

// import { toBig } from "@remora/utils/precision.mjs"

import { balances } from '../data/seed.mjs'

const clearBalance = (balance = {}) => {
  const cleared = {
    margin: 0,
  }
  Object.assign(balance, cleared)

  return balance
}

export const getBalances = (user, symbol, platform) => {
  if (!user && !symbol && !platform)
    return balances

  if (user === 'remora') {
    if (symbol) {
      if (platform) {
        if (!balances[user][platform])
          balances[user][platform] = {}

        if (!balances[user][platform][symbol])
          balances[user][platform][symbol] = clearBalance()

        const balance = balances[user][platform][symbol]

        return balance
      } else {
        return Object.entries(balances[user]).reduce((acc, [pf, symbols]) => {
          let balance = symbols[symbol]
          if (!balance)
            balance = balances[user][pf][symbol] = clearBalance()

          const { total, long, short } = balance

          acc.total += total
          acc.long += long
          acc.short += short

          return acc
        }, clearBalance())
      }
    } else
      return balances[user]
  } else {
    if (!balances[user])
      balances[user] = clearBalance()

    return balances[user]
  }
}

export const setBalance = ({ user, platform, symbol, balance }) => {
  if (user && symbol && balance) {
    if (!platform) {
      if (!balances[user])
        balances[user] = {}

      const userBalance = balances[user]
      if (!userBalance)
        balances[user] = clearBalance()

      const r = balances[user] = {
        ...userBalance,
        ...balance,
      }
      return r
    } else
      throw new Error(`Not implemented: setBalance(${user}, ${platform}, ${symbol}, ${balance})`)
  } else
    throw new Error(`Not implemented: setBalance(${user}, ${platform}, ${symbol}, ${balance})`)
}

const init = data => Object.assign(balances, data)

export const patch = (diff, state = balances) => {
  const result = Object.keys(diff).reduce((update, user) => {
    const balance = state[user] || clearBalance()

    const updated = Object.keys(diff[user]).reduce((balance, k) => ({
      ...balance,
      [k]: +balance[k] + +diff[user][k],
    }), balance)

    return { ...update, [user]: updated }
  }, {})

  return result
}

const update = data => Object.keys(data).reduce((result, user) => {
  const updated = Object.assign(balances[user], data[user])

  return {
    ...result,
    [user]: updated,
  }
}, {})

export default {
  get: getBalances,
  set: setBalance,
  init,
  patch,
  update,
}
