import assert from 'node:assert'

// To validate sequence:
// - extract action from sequence
// - validate by building sequence
// - compare effects with sequence
import buildSequence from './sequences.mjs'
import DataStore, { getState } from '../state/index.mjs'

// TODO : Detect redundant sequences (effects identical to local state)
export const witness = sequence => {
  let seqData

  try {
    seqData = JSON.parse(sequence)
  } catch (e) {
    console.error(e)
    return
  }

  const {
    type,
    [type]: actionType,
    [actionType]: action,
    diff: _, // TODO compare diff
    ...effects
  } = seqData

  // console.log(type, actionType, action, 'witness::action')

  const state = getState()
  try {
  // build sequence
    const local = buildSequence(action)

    const localEffects = local.apply(state)

    try {
      assert.deepStrictEqual(effects, localEffects, `Discarded ${type}:${actionType} sequence.`)

      DataStore.update(localEffects)
      console.info(`Witnessed ${type}:${actionType} sequence.`)
      // console.log(JSON.stringify({
      //   effects,
      //   local: localEffects,
      // }, null, 2), 'witness::effects::apply')
    } catch (e) {
      console.log(e.message)
      // console.log(JSON.stringify({
      //   effects,
      //   local: localEffects,
      // }, null, 2), 'witness::effects::discard')
    }
  } catch (e) {
    console.error('Error processing sequence')
  }
}
