import assert from 'node:assert'

// import userSequencer from './sequences/users.mjs'
import orderSequencer from './sequences/orders.mjs'

// import incrementSequencer from './sequences/increment.mjs'

export const sequencers = {
//   user: userSequencer,
  order: orderSequencer,
}

export const buildSequence = (action, provided = sequencers) => {
  assert(action, 'Invalid action')
  // TODO : single string action ('increment:a', 'trade:ethusdt:buy:market:1.0')
  assert.strictEqual(typeof action, 'object', 'Invalid action')

  const { type } = action
  assert.strictEqual(typeof type, 'string', `Invalid action type ${type}`)

  const resource = action[type]
  if (provided[resource])
    return provided[resource][action.type](action)

  if (typeof provided[type] === 'function')
    return provided[type](action)

  throw new Error(`No sequencer provided for action ${type}:${resource}`)
}

export default buildSequence
