import assert from 'node:assert'

import { hash } from './hash.mjs'

import build from './sequences.mjs'

export const seq = Symbol('sequence')
export const nullSeq = Object.freeze({ s: 0, h: 0, c: 0 })
export const nullRoot = Object.freeze({ [seq]: nullSeq })

export const Init = seed => {
  if (!seed) {
    const h = hash(nullRoot)
    return ({
      [seq]: {
        s: 0,
        h,
        c: h,
      },
    })
  }

  assert(!seed[seq], 'seed has sequence')

  const h = hash(seed)

  return ({
    [seq]: {
      ...nullSeq,
      h: 1,
      c: h,
    },
    ...seed,
  })
}

export const NullSeq = inp => {
  if (!inp) return structuredClone(nullSeq)

  return Init(inp)
}

export const fromAction = build

export const applyAction = (state, action) => build(action).apply(state)

const sequence = (state, action) => action
  ? applyAction(state, action)
  : Init(state)

export default sequence
