import { relay } from '@remora/config/config.mjs'

import { createClient } from 'redis'

const redis = createClient(relay)
const client = redis.duplicate()

const connected = {
  pub: redis.connect(),
  sub: client.connect(),
}

export const listen = async (channel, listener) => {
  await connected.sub

  try {
    await client.subscribe(channel, listener)

    return _ => client.unsubscribe(channel, listener)
  } catch (err) {
    console.error(err, 'Failed to subscribe to channel', channel)
  }
}

export const broadcast = async (message, channel) => {
  await connected.pub

  // console.log({
  //   channel,
  //   message,
  // }, 'in broadcast')

  return redis.publish(channel, JSON.stringify(message))
}

export default {
  listen,
  broadcast,
}
