import { persist } from '../data/db.mjs'
import relay, {
// broadcast,
// listen,
} from './relay.mjs'

import DataStore, { getState } from '../state/index.mjs'

import buildSequence from './sequences.mjs'
import { witness } from './witness.mjs'

import liquidator from './liquidator.mjs'
import { dump } from '@remora/utils'

// TODO : Liquidate :D
let lastLiqNotification = 0
liquidator.on('illiquid', positions => {
  const ts = Date.now()

  if (ts - lastLiqNotification > 60 * 1000) {
    dump(positions, 'illiquid')
    lastLiqNotification = ts
  }
})

// import { executeOrder } from './order.mjs'
const execute = async action => {
  console.log(`Action::${action.type}::${typeof action[action.type]}`)

  const { type, [type]: data, ...meta } = action

  if (!type)
    throw new Error(`No execution for type ${type}`)
  if (!action[type])
    throw new Error(`No ${type} payload.`)

  const sequence = buildSequence(action)

  const state = getState()
  const diff = await sequence.run(state)

  if (diff) {
    const result = sequence.apply(state)
    DataStore.update(result)

    const { type: _, ...addData } = data
    const addAction = { ...addData, ...meta }
    const persisted = Object.entries({
      [`${type}s`]: { '': addAction },
      ...result,
    }).map(([resource, data]) => Object.entries(data)
      .map(([addr, value]) => persist(resource, value, addr)))
    Promise.all(persisted.flat())
      .then(
        // persisted => { console.log(JSON.stringify(persisted, null, 2), 'persisted::result') }
      )

    const seq = {
      action,
      diff,
      result,
    }
    persist('sequences', seq)
      .then(_persisted => {
        // console.log(JSON.stringify(seq, null, 2), 'persisted::sequence')
        // console.log(JSON.stringify(persisted, null, 2), 'sequence::persisted')
      })

    const execution = {
      type: 'action',
      action: action.type,
      [action.type]: sequence.action || action,
      ...result, // effects
    }

    relay.broadcast(execution, 'executions')
      .then()

    return execution
  }
}

export const engine = {
  execute,
  witness,
}

// const _unsub = listen('executions', engine.witness)
relay.listen('executions', engine.witness).then()

export {
  engine as default,
}
