export const hString = str => hIter(str, fromString)
export const fromString = c => c.charCodeAt(0)
export const hObj = (obj, coers = { k: null, v: null }) => {
  const { k, v } = coers

  const h = Object.keys(obj).sort().reduce((h, key) => {
    const value = obj[key]

    const hKey = k ? k(key) : key
    const hValue = v ? v(value) : value

    return hash(h, hKey, hValue)
  }, 0)

  return h
}

export const h = (a = 0, b = 0) => (a * 33) ^ b
export const hIter = (iter, coers) => {
  let hIt = 0

  for (let item of iter) {
    if (coers) item = coers(item)

    hIt = hash(hIt, item)
  }
  return hIt
}

export const hash = (...values) => {
  return values.reduce((prev, value) => {
    if (!value)
      return prev

    // if (value[seq])
    //     return hash(prev, value[seq].h)

    if (typeof value === 'string')
      return hash(prev, hString(value))

    if (typeof value === 'object')
      return hash(prev, hObj(value))

    if (typeof value === 'boolean')
      return hash(prev, value ? 1 : 0)

    if (typeof value !== 'number')
      throw new TypeError(`Invalid primitive ${value} of type ${typeof value}`)

    return h(prev, value)
  }, 0)
}

export default hash
