export const addUser = ({ addr, ...data }) => ({
  type: 'add',
  add: 'user',
  user: addr,
  [addr]: data,
})

export const updateUser = ({ addr, ...data }) => ({
  type: 'update',
  update: 'user',
  user: addr,
  [addr]: data,
})

export const deleteUser = addr => ({
  type: 'delete',
  delete: 'user',
  user: addr,
})

export default {
  add: addUser,
  update: updateUser,
  delete: deleteUser,
}
