export const into = async (db, set, data, id) => {
  const { type, [type]: action, ...meta } = data

  const filter = {}
  const document = action
    ? { type, action, meta, timestamp: Date.now() }
    : { ...data }
  if (id)
    filter._id = document._id = id

  try {
    let result

    if (id)
      result = await db?.collection(set).updateOne(filter, { $set: document }, { upsert: true })
    else
      result = await db?.collection(set).insertOne(document)

    return { document, result }
  } catch (err) {
    console.warn({ set, document }, 'Failed to persist data', err)

    return null
  }
}
