import eth from '@ethereumjs/util'

import { buildMessage } from '@remora/utils/auth.mjs'

export const validateSignature = ({ sig, ...payload }) => {
  const msg = buildMessage(payload)
  console.log('Reconstructed message :')
  console.log(msg)

  const { v, r, s } = eth.fromRpcSig(sig)
  const pubKey = eth.ecrecover(eth.hashPersonalMessage(Buffer.from(msg)), v, r, s)
  const address = eth.bufferToHex(eth.pubToAddress(pubKey))

  console.log(`Signer's address : ${address}`)
  console.log(`Declared address : ${payload.from}`)
  const validated = address === payload.from.toLowerCase()

  console.log(validated
    ? '✅ Addresses match ✨'
    : '❌ Challenge error 🚫')

  return validated && address
}

// TODO
export const authorize = request => {
  const {
    'x-api-key': key,
    'x-api-cid': cid,
    'x-api-exp': exp,
    'x-api-iat': iat,
  } = request.headers

  if (!cid || !exp || !iat || !key)
    return false

  return { key, cid, exp, iat }
}
