#!/bin/bash
#Ttoocs's Launcher for the Linux (and maybe mac) version of RimWorld
#Originally posted here: https://ludeon.com/forums/index.php?topic=4805.msg236661#msg236661
#For use if the default launcher doesn't work. Can solve certain compatibility problems.

LOGFILE="/tmp/rimworld_log_$UID"

#VERSION=1.0

#Due to bash, all functions are defined before their use.

#Code to check if the prior run had an SDL::Logic_error
check_prior_sdllogic_crash() {
if [ -e $LOGFILE ]; then
	if grep -q "std::logic_error" $LOGFILE ; then
		FORCEGL=" -force-opengl"
		echo "Detected a prior crash in logfile due to too low an OpenGL version, Launching game with a fix"
	fi
fi
}


#Code to check for OpenGL > 3.2, and set --force-opengl if required
setargs_force_opengl(){			
FORCEGL=""		#Assume all is okay until proven not.

if which glxinfo | grep -q glxinfo ; then
	OPENGL_VERSION=`glxinfo | grep "OpenGL version string:" | cut -d' ' -f 4`
	if [[ (( $OPENGL_VERSION < 3.2 )) ]]; then
		echo "Detected OpenGL versoin < 3.2, launching game with a fix"
		FORCEGL=" -force-opengl"
	else
		check_prior_sdllogic_crash
	fi	
fi

}

rungame(){
	#Runs the game, and if it detects a crash from sdl:logic error, where -force-opengl was no set,  re-runs the game"
	#Echo's a forceGL string to the logfile at the end, if it didn't crash while running it that way
		#

	#run the game
	./$GAMEFILE $LOG $FORCEGL $@

	EXITVAL=$?	#Get the exit value

	if [[ $EXITVAL != "0" ]]; then	#Check if it had an unclean exit
		if [[ $FORCEGL == "" ]]; then #Check if -force-opengl was set
			check_prior_sdllogic_crash
			if [[ $FORCEGL != "" ]]; then #Check for sdlogic crash

				echo "Sorry, the game crashed without the fix... trying again with it!"
				#MAIN# (A copy-paste)
				OS=`uname -s`
				if [[ $OS == "Darwin" ]]; then
				    runmacstuff
				else
				    runlinuxstuff
				fi

			fi
		else
			echo "Sorry, game still crashed with the -force-opengl fix."	
		fi
	else
		#Game exited okay!
		if [[ $FORCEGL != "" ]]; then	#Check if the fix was used.
			echo  "Appending fix to new logfile"
			echo  "Ttoocs script crash-saving thing std::logic_error" >> $LOGFILE		#If it was, copy a trigger to run it again into the newest logfile
		fi
	fi
}


#Runs the required mac-stuff
runmacstuff()	{
#NOTE: From pk4yahweh's case, this script _WILL NOT_ catch the case where Mac OSX runs the game in software rendering when glxgears is not installed.
		#I'm not entierly sure how to fix that.

#NOTE: I'm not sure where it would be if installed via steam on a mac..
#  		If it's possible to ship this script (and make it runnable as osx needs)
#		then you can do a simmilar approch to linux.


if [ -d /Applications/RimWorld*Mac.app/Contents/MacOS/ ]; then
	#Check if mac hdd install'd
	DIR="/Applications/RimWorld*Mac.app/Contents/MacOS/"
else
	if ls | egrep -i rimworld | egrep -q -i mac$ ; then		#Cheks if it's in the game directory
		DIR=`pwd`
	else
		#TODO: More/better detection of mac folders
		echo "Not sure where the game is, sorry!"
		exit
	fi
fi

cd "$DIR"

#Get's the gamefile
GAMEFILE=`ls | egrep -i rimworld | egrep -i mac$`

#Sets a logfile
LOG="-logfile "$LOGFILE

#Sets the forcegl arg
setargs_force_opengl 

rungame

}

#Runs the linux stuff
runlinuxstuff()	{	

# cd into the directory containing this script
SCRIPT=$(readlink -f "$0")
DIR=$(dirname "$SCRIPT")
cd "$DIR"

#Getting game executable name.
GAMEFILE="RimWorldLinux"

LOG="-logfile "$LOGFILE

export LC_ALL=C #Locale resetting (important for Ubuntu players who are not native speakers of English) and launching the game.

#Sets the forcegl arg
setargs_force_opengl

rungame
}


#MAIN#

OS=`uname -s`
if [[ $OS == "Darwin" ]]; then
	runmacstuff
else
	runlinuxstuff
fi

