#!/bin/bash
#Launcher for the Linux version of RimWorld

# cd into the directory containing this script
SCRIPT=$(readlink -f "$0")
DIR=$(dirname "$SCRIPT")
cd "$DIR"

#Getting game executable name.
GAMEFILE="RimWorldLinux"

#Puts the game executable as... executable if not the case.
if [ ! -x $GAMEFILE ]
    then chmod +x $GAMEFILE
fi

#If this is a dev version, we want to activate logs.
#if [[ $GAMEFILE == *Dev* ]]
#    then LOG="-logfile /tmp/rimworld_log"
#    else LOG=""
#fi

#We always want to activate logs
LOG="-logfile /tmp/rimworld_log_$UID"

#Locale resetting (important for Ubuntu players who are not native speakers of English) and launching the game.
LC_ALL=C ./$GAMEFILE $LOG