using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Verse;

namespace RimWorld
{

public class IncidentWorker_TransportPodCrash : IncidentWorker
{
	protected override bool TryExecuteWorker( IncidentParms parms )
	{
		var map = (Map)parms.target;

		var contents = ThingSetMakerDefOf.RefugeePod.root.Generate();
		var dropSpot = DropCellFinder.RandomDropSpot(map);
		var refugee = ThingUtility.FindPawn(contents);
		refugee.guest.getRescuedThoughtOnUndownedBecauseOfPlayer = true;

		TaggedString letterTitle = "LetterLabelRefugeePodCrash".Translate();
		TaggedString letterText = "RefugeePodCrash".Translate(refugee.Named("PAWN")).AdjustedFor(refugee);

		letterText += "\n\n";
		if( refugee.Faction == null )
			letterText += "RefugeePodCrash_Factionless".Translate(refugee.Named("PAWN")).AdjustedFor(refugee);
		else if( refugee.Faction.HostileTo(Faction.OfPlayer) )
			letterText += "RefugeePodCrash_Hostile".Translate(refugee.Named("PAWN")).AdjustedFor(refugee);
		else
			letterText += "RefugeePodCrash_NonHostile".Translate(refugee.Named("PAWN")).AdjustedFor(refugee);

		PawnRelationUtility.TryAppendRelationsWithColonistsInfo(ref letterText, ref letterTitle, refugee);
		SendStandardLetter(letterTitle, letterText, LetterDefOf.NeutralEvent, parms, new TargetInfo(dropSpot, map));

		var podInfo = new ActiveDropPodInfo();
		podInfo.innerContainer.TryAddRangeOrTransfer(contents);
		podInfo.openDelay = 180;
		podInfo.leaveSlag = true;
		DropPodUtility.MakeDropPodAt( dropSpot, map, podInfo );	

		return true;
	}
}

}
